using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;

/// <summary>
/// Skorzystaj z tej klasy do reprezentacji nagwka
/// SOAP. Zostanie on  zserializowany i zdeserializowany
/// w ramach otoczki SOAP dla celw transmisji
/// </summary>
public class TestSoapHeader : SoapHeader
{
   public string FirstValue;
   public string SecondValue;
}
/// <summary>
/// Summary description for SoapHeaderTest
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class SoapHeaderTest : System.Web.Services.WebService
{
   public TestSoapHeader TestHeader;
   public SoapHeaderTest() 
   {

      // Zdejmij komentarz z poniszego wiersza jeli korzystasz z zaprojektowanych komponentw
      // InitializeComponent();
   }

   [WebMethod]
   public string HelloWorld() {
      return "Witaj wiecie";
   }

   [WebMethod]
   [SoapHeader("TestHeader", Direction = SoapHeaderDirection.InOut)]
   public string HeaderEnabledMethod(string message)
   {
      if (TestHeader != null)
      {
         string output = string.Format(
           "Wysany komunikat to '{0}'. Nagwek SOAP zawiera {1} i {2}.",
           message, TestHeader.FirstValue, TestHeader.SecondValue);
         TestHeader.FirstValue += " (zmodyfikowane)";
         TestHeader.SecondValue += " (zmodyfikowane)";
         return output;
      }
      else
         return string.Format(
           "Wysany komunikat to '{0}'", message);
   }
}
